package gov.va.med.mhv.integration.phr.dao;

import gov.va.med.mhv.integration.phr.transfer.Extract;
import gov.va.med.mhv.integration.phr.transfer.ExtractLog;
import gov.va.med.mhv.integration.phr.transfer.FacilityExtractStatus;
import gov.va.med.mhv.integration.phr.transfer.FacilityInfo;
import gov.va.med.mhv.integration.phr.transfer.PatientIdentifier;

import java.util.Date;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public interface TransferDAO {

	void setStatusTable(String statusTable);

	Hashtable<String, FacilityInfo> findAllFacilities();

	Set<String> findStationNumbersByIcn(String icn);

	Map<String, Extract> findEnabledExtracts();

	void save(ExtractLog log);

	List<FacilityExtractStatus> findEnabledExtractsByIcn(String icn);

	boolean isFieldTester(String icn, String accessRoleName);

	Date findCompletedExtractByIcnAndMessageName(String icn, String messageName);
	
	/**
	 * Find the list of facility patient identifiers that correlated to the provider 
	 * patient ID. 
	 * 
	 * @param pid The identifier to correlate with (typically an ICN - but not necessarily).
	 * @return The list of facility patient identifiers.
	 */
	List<PatientIdentifier> findFacilityPatientIds(PatientIdentifier pid);

}